/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.axiom;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import net.skinsrestorer.shadow.axiom.AxiomConfigurationSection;
import net.skinsrestorer.shadow.snakeyaml.DumperOptions;
import net.skinsrestorer.shadow.snakeyaml.LoaderOptions;
import net.skinsrestorer.shadow.snakeyaml.Yaml;
import net.skinsrestorer.shadow.snakeyaml.constructor.BaseConstructor;
import net.skinsrestorer.shadow.snakeyaml.constructor.Constructor;
import net.skinsrestorer.shadow.snakeyaml.nodes.MappingNode;
import net.skinsrestorer.shadow.snakeyaml.representer.Representer;

public class AxiomConfiguration
extends AxiomConfigurationSection {
    public AxiomConfiguration() {
        this(2, 2);
    }

    public AxiomConfiguration(int indent, int indicatorIdent) {
        super(AxiomConfiguration.generateYAML(indent, indicatorIdent), null);
        this.rootNode = (MappingNode)this.yaml.represent(Collections.emptyMap());
    }

    private static Yaml generateYAML(int indent, int indicatorIdent) {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setProcessComments(true);
        DumperOptions dumper = new DumperOptions();
        dumper.setProcessComments(true);
        dumper.setIndent(indent);
        dumper.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumper.setIndicatorIndent(indicatorIdent);
        dumper.setIndentWithIndicator(true);
        dumper.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        dumper.setAllowUnicode(true);
        dumper.setSplitLines(false);
        Constructor constructor = new Constructor(loaderOptions);
        Representer representer = new Representer();
        return new Yaml((BaseConstructor)constructor, representer, dumper, loaderOptions);
    }

    public void load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            this.load(reader);
        }
    }

    public void load(InputStream input) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            this.load(reader);
        }
    }

    public void load(String string) throws IOException {
        try (StringReader reader = new StringReader(string);){
            this.load(reader);
        }
    }

    public void load(Reader reader) throws IOException {
        try {
            this.rootNode = (MappingNode)this.yaml.compose(reader);
        }
        catch (Exception e) {
            throw new InvalidObjectException("Invalid configuration file");
        }
    }

    public void save(Path path) throws IOException {
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            out.write(this.saveToString());
        }
    }

    public String saveToString() {
        StringWriter writer = new StringWriter();
        this.yaml.serialize(this.rootNode, writer);
        return writer.toString();
    }
}

